﻿$(document).ready(function () {
    initSliders();
});

function initSliders() {
    $(".sliderBar").each(function () {
        var sliderContent = $(this).closest(".sliderContents");
        var trailingColor = sliderContent.attr("data-trailingcolor");
        var cursorColor = sliderContent.attr("data-cursorcolor");
        var cursorImage = sliderContent.find(".cursorImage");
        var isRTL = document.dir == "rtl";

        if (trailingColor) {
            $(this).uislider({ range: "min", isRTL: isRTL });
            $(".ui-slider-range", sliderContent).css("background", trailingColor);
        }
        else {
            $(this).uislider({ isRTL: isRTL });
        }
        var sliderHandle = $(".ui-slider-handle", sliderContent);

        if (cursorImage.attr("src")) {
            sliderHandle.hide();
            SetSliderCursorImage($(this), sliderHandle, cursorImage);
        }
        else {
            if (cursorColor) {
                sliderHandle.css("background", cursorColor);
            }

            if (sliderContent.height() > 15) {
                sliderHandle.height(sliderContent.height() - (sliderHandle.position().top));
            }

            sliderHandle.hide();
            CreateSlider($(this), sliderHandle);
        }
    });

    $(".sliderContainer").each(function () {
        var gridItem = $(this).closest(".gridItem");
        var leftWidth = $(".sliderContentsRow .sliderLeft", gridItem).width();
        var rightWidth = $(".sliderContentsRow .sliderRight", gridItem).width();

        if (gridItem.length > 0 && (leftWidth == 0 || rightWidth == 0)) {
            gridItem.css("padding", "3px 15px");
        }
    });

    $("input.sliderValue").on("change", function () {
        if (isInGrid($(this))) {
            toggleGridOpenEnds($(this));
        }
    });
}

function SetSliderCursorImage(slider, sliderHandle, cursorImage) {
    cursorImage.hide();

    $(cursorImage).imagesLoaded(function () {
        var sliderContent = slider.closest(".sliderContents");
        var hideCursor = sliderContent.attr("data-hidecursor");
        cursorImage.show();
        var cursorHeight = cursorImage.height();
        var cursorWidth = cursorImage.width();
        cursorImage.hide();

        var cursorStyle = "background:url('" + cursorImage.attr("src") + "') no-repeat; width:" + cursorWidth + "px; height:" + cursorHeight + "px; border:0px; margin-left:-" + Math.floor(cursorWidth / 2) + "px; display:none;";
        sliderHandle.attr("style", cursorStyle);

        var sliderBarHeight = slider.height();
        var top = (sliderBarHeight / 2) - (cursorHeight / 2);
        var topVal = Math.ceil(Math.abs(top)) * (top / Math.abs(top));

        // Only set if we have a number
        if (!isNaN(topVal)) {
            sliderHandle.css("top", topVal + "px");
        }

        CreateSlider(slider, sliderHandle);
    });
}

function CreateSlider(slider, sliderHandle) {
    var sliderContent = slider.closest(".sliderContents");
    var mainDiv = sliderContent.closest(".sliderContainer");
    var sliderValue = mainDiv.find('.sliderValue');
    var sliderCurrentValue = mainDiv.find('.sliderCurrentValue');
    var sliderType = sliderContent.attr("data-slidertype");
    var noAnswerCheckBox = mainDiv.find(".noAnswer");
    var softPromptCheckBox = mainDiv.find(".softPromptSliderCheckbox");
    var hideCursor = sliderContent.attr("data-hidecursor");
    var followCursor = sliderCurrentValue.closest(".sliderCurrentValueFollow");

    sliderHandle.on("focus", function () {
        if (!noAnswerCheckBox.is(":checked") && !softPromptCheckBox.is(":checked")) {
            var selectedValue = slider.uislider("value");
            slider.uislider("value", selectedValue);
            if (sliderType == "Discrete") {
                sliderValue.val(sliderContent.attr("data-choicevalue" + selectedValue));
                sliderCurrentValue.html(GetCurrentValueHtml(sliderContent, selectedValue));
            }
            else {
                sliderValue.val(selectedValue);
                sliderCurrentValue.text(selectedValue);
            }

            sliderValue.trigger('change');

            if (hideCursor != "true") {
                sliderHandle.show();
            }
        }
    });

    slider.on("slide", function (event, ui) {
        if (hideCursor != "true") {
            sliderHandle.show();
        }

        if (sliderType == "Discrete") {
            sliderValue.val(sliderContent.attr("data-choicevalue" + ui.value));
            sliderCurrentValue.html(GetCurrentValueHtml(sliderContent, ui.value));
        }
        else {
            sliderValue.val(ui.value);
            sliderCurrentValue.text(ui.value);
        }

        if (followCursor.length > 0) {
            var UpdateFollowCursorValue = function () {
                sliderHandle.show();
                var position = sliderHandle.offset();
                if (hideCursor) {
                    sliderHandle.hide();
                }

                if (followCursor.hasClass("followBottom")) {
                    position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
                    position.top += sliderHandle.height() + 3;
                }
                else if (followCursor.hasClass("followTop")) {
                    position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
                    position.top -= 16;
                }
                else if (followCursor.hasClass("followLeft")) {
                    position.left -= 16;
                    position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
                }
                else {
                    position.left += sliderHandle.width() + 10;
                    position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
                }

                followCursor.offset(position);
            }

            setTimeout(UpdateFollowCursorValue, 10);
        }

        sliderValue.trigger("change");
    });

    var updateSliderValueFromCheckbox = function (checkbox) {
        if (checkbox.is(":checked")) {
            sliderCurrentValue.html("");
            sliderValue.val(checkbox.val());
            slider.uislider("disable");
        }
        else {
            sliderCurrentValue.html(GetCurrentValueHtml(sliderContent, slider.uislider("value")));
            if (sliderType == "Discrete") {
                sliderValue.val(sliderContent.attr("data-choicevalue" + slider.uislider("value")));
            }
            else {
                sliderValue.val(slider.uislider("value"));
            }
            slider.uislider("enable");
        }
        sliderValue.trigger("change");
    };

    noAnswerCheckBox.on("click", function () { updateSliderValueFromCheckbox($(this)); });

    softPromptCheckBox.on("click", function () { updateSliderValueFromCheckbox($(this)); });

    // Set slider min and max values

    var minValue = Number(sliderContent.attr("data-minvalue"));
    var maxValue = Number(sliderContent.attr("data-maxvalue"));
    var defaultValue = Number(sliderContent.attr("data-defaultvalue"));

    slider.uislider("option", "min", minValue);
    slider.uislider("option", "max", maxValue);

    // Set slider initial value
    var value = sliderValue.val();

    if (value == null || value == "") {
        if (defaultValue >= minValue) {
            value = defaultValue;
        }
    }

    var cursorPosition = sliderContent.attr("data-cursorposition");

    if (value == null || value == "") {
        var hideCursor = sliderContent.attr("data-hidecursor");

        if (cursorPosition == "Middle") {
            slider.uislider("value", (maxValue + minValue) / 2);
        }
        else if (cursorPosition == "Right") {
            slider.uislider("value", maxValue);
        }
    }
    else {
        if (value == noAnswerCheckBox.val()) {
            noAnswerCheckBox.prop("checked", true);
            slider.uislider("disable");
        }
        else if (value == softPromptCheckBox.val()) {
            softPromptCheckBox.prop("checked", true);
            slider.uislider("disable");
        }
        else {
            sliderValue.val(value);
            if (sliderType == "Discrete") {
                var sliderPosition = 0;

                for (sliderPosition = minValue; sliderPosition <= maxValue; sliderPosition++) {
                    if (sliderContent.attr("data-choicevalue" + sliderPosition) == value) {
                        break;
                    }
                }

                if (sliderPosition <= maxValue) {
                    slider.uislider("value", sliderPosition);
                    sliderCurrentValue.html(GetCurrentValueHtml(sliderContent, sliderPosition));
                }
            }
            else {
                slider.uislider("value", value);
                sliderCurrentValue.text(value);
            }
        }
    }

    if (followCursor.length > 0) {
        sliderHandle.show();
        var position = sliderHandle.offset();
        sliderHandle.hide();

        if (followCursor.hasClass("followBottom")) {
            position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
            position.top += sliderHandle.height() + 3;
        }
        else if (followCursor.hasClass("followTop")) {
            position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
            position.top -= 16;
        }
        else if (followCursor.hasClass("followLeft")) {
            position.left -= 16;
            position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
        }
        else {
            position.left += sliderHandle.width() + 10;
            position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
        }

        followCursor.offset(position);
    }

    if ((cursorPosition != "Hidden" || (value != null && value != "")) && hideCursor != "true") {
        sliderHandle.show();
    }

    SetSliderDimensions(slider);
}

function SetSliderDimensions(slider) {
    if (slider.is(":visible")) {
        var sliderContent = slider.parents(".sliderContents");
        var mainDiv = sliderContent.parents(".sliderContainer");

        var leftWidth = $(".sliderContentsRow .sliderLeft", mainDiv).width();
        var rightWidth = $(".sliderContentsRow .sliderRight", mainDiv).width();
        var contentWidth = sliderContent.width();

        if (contentWidth < 10) {
            if (slider.parents('.gridItem').length > 0) {
                contentWidth = mainDiv.width() - leftWidth - rightWidth;

                if (contentWidth < 150) {
                    contentWidth = 150;
                    slider.parents('.gridItem').width(contentWidth + leftWidth + rightWidth);
                }

                sliderContent.width(contentWidth);
                $(".sliderContentsRow .sliderLeft", mainDiv).width(leftWidth);
                $(".sliderContentsRow .sliderRight", mainDiv).width(rightWidth);
            }
            else {
                slider.width(300);
                contentWidth = sliderContent.width();
            }
        }

        $(".sliderCurrentValueRow .sliderLeft", mainDiv).width(leftWidth);
        $(".sliderCurrentValueRow .sliderRight", mainDiv).width(rightWidth);
        $(".sliderCurrentValueRow .sliderCurrentValue", mainDiv).width(contentWidth);
    }
}

function GetCurrentValueHtml(sliderContent, value) {
    var html = "";

    if (sliderContent.attr("data-choiceimage" + value) != null && sliderContent.attr("data-choiceimage" + value) != "") {
        html += "<img src='" + sliderContent.attr("data-choiceimage" + value) + "'>"
    }

    if (sliderContent.attr("data-choicelabel" + value) != null && sliderContent.attr("data-choicelabel" + value) != "") {
        html += "<div>" + sliderContent.attr("data-choicelabel" + value) + "</div>";
    }

    return html;
}